--[[
	Bongos Minimap
		Zone Bar
--]]


local Bongos = LibStub('AceAddon-3.0'):GetAddon('Bongos3')
local Zone = Bongos:NewModule('Zone')
local L = LibStub('AceLocale-3.0'):GetLocale('Bongos3-Minimap')


--[[ Startup ]]--

function Zone:Load()
	local defaults = {
		showBorder = true,
		point = "TOPRIGHT",
		x = -3.6,
		y = -1.3,
	}

	local bar, isNew = Bongos.Bar:Create('zone', defaults, 'LOW')
	if isNew then
		self.LoadBar(bar)
	end
	
	bar:ToggleBorder(bar.sets.showBorder)
	
	self.bar = bar
end

function Zone:Unload()
	self.bar:Destroy()
end

function Zone:LoadBar()

	for k,v in pairs(Zone) do self[k] = v end
	self:SetHeight(23)

	self.border = MinimapBorderTop
	self.border:ClearAllPoints()
	self.border:SetPoint("CENTER", self, -8, -3.5)
	self.border:SetParent(self)

	self.button = MinimapToggleButton
	self.button:ClearAllPoints()
	self.button:SetPoint("RIGHT", self.border, "RIGHT", 1, 3.5)
	self:Attach(self.button)
	
	self.text = MinimapZoneTextButton
	self.text:SetScript("OnClick", ToggleMinimap)
	self:Attach(self.text)
	
end


--[[ Configuration ]]--

function Zone:ToggleBorder(enable)
	if enable then
		self:SetWidth(170)
		
		self.border:Show()
		self.button:Show()
		
		self.text:ClearAllPoints()
		self.text:SetPoint("Center", self.border, "Center", 0, 3)
	else
		self:SetWidth(128)
		
		self.border:Hide()
		self.button:Hide()
		
		self.text:ClearAllPoints()
		self.text:SetPoint("Center", self)
	end
	
	self.sets.showBorder = enable
end


--[[ Menu ]]--

function Zone:CreateMenu()

	local menu = Bongos.Menu:Create(self.id)
	local panel = menu:AddLayoutPanel()
	
	local showBorder = panel:CreateCheckButton(L.ShowBorder)
	showBorder:SetScript("OnShow", function(b) b:SetChecked(self.sets.showBorder) end)
	showBorder:SetScript("OnClick", function(b) self:ToggleBorder(b:GetChecked()) end)
	
	return menu
end